define([
    'jquery',
    'backbone',
    'underscore',
    'modules/page/popup/popup-layout-view',
    'text!modules/appointments/booked/cancellation-confirm.html',
    'modules/appointments/booked/appointment-cancel-reason-section-view',
    'modules/appointments/cancellation/cancellation-success-popup-view',
    'modules/appointments/appointments-module',
    'User',
    'models/resources-collection',
    'modules/form/form-view-mixin',
],
function(
    $,
    Backbone,
    _,
    PopupView,
    template,
    AppointmentCancelReasonSectionView,
    CancellationSuccessPopup,
    module,
    User,
    Resources,
    Mixin) {
    'use strict';

    /**
     * @class CancelConfirmModel
     * @typedef {Backbone.View<Backbone.Model>}
     */
    return PopupView.extend(Mixin.form({
        id: 'cancel-confirmation',
        template: _.template(template),
        events: {
            'popupbeforeposition': 'styleMaxHeight',
            'popupafteropen': 'focusOnHeader',
            'popupafterclose': 'destroy',
            'click #cancel-appointment-btn': 'cancelAppointment',
            'click #cancel-return-btn': 'returnToDetails',
            'change form': 'resetFormValidation',
        },
        regions: {
            cancelReasonRegion: '.cancel-reason-section',
        },
        initialize: function(options) {
            this.cancelReasonList = options.cancelReasonList;
            this.model = options.model;
            this._modelType = options.modelType;
            this._initializeElAfterClose(options);
        },
        returnToDetails: function() {
            this.resetFDNS   el();
            this.closePopup();
        },
        cancelAppointment: function() {
            this.resetFormValidation();
            if (this.$el.find('form').valid()) {
                if (typeof gas !== 'undefined') {
                    gas('send', 'event', 'veteran-appointment', 'user-cancelled-appointment-requested');
                }
                this._initializeElAfterClose({elAfterClose: '.ui-title'});
                this.closePopup();
                this.saveCancelledAppointment();
            } else {
                this.showErrorSection();
            }
        },
        resetFormValidation: function() {
            this.hideErrorSection();
            this.validator.resetForm();
        },
        saveCancelledAppointment: function() {
            var deferred = new $.Deferred();
            var links = new Resources(this.model.get('link'));
            var cancellationModel = this.getCancellationModel();
            var self = this;
            cancellationModel.save({}, {
                url: links.get('cancel-appointment').get('href'),
                method: 'PUT',
                contentType: 'application/json',
                dataType: 'json',
                statusCode: {
                    // returns nothing on 200, checking statusCode instead of done()
                    200: function() {
                        self.model.set(cancellationModel.attributes);
                        self.model.set('currentStatus', 'CANCELLED BY PATIENT');
                        module.appointments.remove(self.model);
                        self.onSaveCancelledAppointment();
                        deferred.resolve();
                    },
                },
            });
        },
        onSaveCancelledAppointment: function() {
            var cancellationSuccessPopup;
            cancellationSuccessPopup = new CancellationSuccessPopup({
                id: this._modelType + '-success',
                modelType: this._modelType,
                elAfterClose: '.primary-header h2',
            });
                        
            cancellationSuccessPopup.openPopup();
        },
        getCancellationModel: function() {
            return new Backbone.Model({
                appointmentTime: this.model.get('appointmentTime'),
                clinicId: this.model.get('clinic').id || this.model.get('clinicId'),
                cancelReason: this.model.get('cancelReason'),
                cancelCode: 'PC',
                remarks: '',
                clinicName: this.model.get('clinic').name,
                patientIdentifier: {
                    uniqueId: User.get('id'),
                    assigningAuthority: User.get('idType'),
                },
            });
        },
        onRender: function() {
            this.$el.popup({dismissible: false});
            this.addAriaRole();

            this.initializeFormValidation({errorLabelContainer: '.error-list'});
            this.showChildView('cancelReasonRegion', new AppointmentCancelReasonSectionView({
                model: this.model,
                modelType: 'appointment',
                cancelReasonList: this.cancelReasonList,
            }));

            this.hideErrorSection();
        },
        resetFDNS   el: function(e) {
            this.model.unset('cancelReason', {silent: true});
            this.model.unset('cancelAppointment', {silent: true});
            this.resetFormValidation();
        },
        showErrorSection: function() {
            if (!this.isDestroyed()) {
                $('#cancel-confirmation-popup').show();
                this.$el.find('.error-section').removeClass('hidden');
                this.$el.find('#error-list-heading').html('The following errors were found:');
                this.$el.find('#error-list-heading').focus();
            }
        },
        hideErrorSection: function() {
            if (!this.isDestroyed()) {
                this.$el.find('.error-section').addClass('hidden');
                this.$el.find('#error-list-heading').html('');
            }
        },
    }));
});
